/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSOperation;
import filenet.ws.utils.WSConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSOperationInfoHelper {
    private static final String EL_OPINFO = "OpInfo";
    private static final String ATTR_AUTHENTICATION = "authentication";
    private static final String ATTR_VERSIONAGNOSTIC = "versionAgnostic";
    private static final String ATTR_BASIC = "basic";
    private static final String EL_BASICCORRSET = "basicCorrSet";
    private static final String ATTR_PARAMNO = "paramNo";
    private static final String ATTR_PARAMNAME = "paramName";
    private static final String ATTR_EXPR = "expr";
    private static final String EL_ADVANCEDCORRSET = "advancedCorrSet";
    private static final String ATTR_NAME = "name";
    private static final String EL_PROPERTY = "property";
    private static final String ATTR_QUERY = "query";
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSOperationHelper";
    private boolean m_bAuthentication = false;
    private boolean m_bVersionAgnostic = false;
    private boolean m_bBasic = false;
    private int m_basicCorrSetParamNo = -1;
    private String m_basicCorrSetParamName = null;
    private String m_basicCorrSetParamExpr = null;
    private String m_advCorrSetName = null;
    private String[][] m_advCorrSetProperties = null;
    private static final String BASIC_MARKER = "B";
    private static final String ADV_MARKER = "A";
    private static String[] DEF_BASIC_AGNOSTICS = new String[]{"B"};
    private static String[] DEF_ADV_AGNOSTICS = new String[]{"A"};
    private static final int NPATTERNS = 8;
    private static final String[] XML_ENCODED_PATTERNS = new String[]{"!amp;!", "!gt;!", "!lt;!", "!quot;!", "!apos;!", "!10;!", "!13;!", "!09;!"};
    private static final int[] XML_ENCODED_LEN = new int[]{5, 4, 4, 6, 6, 4, 4, 4};
    private static char[] XML_ENCODED_CHARS = new char[]{'&', '>', '<', '\"', '\'', '\n', '\r', '\t'};

    private static String getRidOfQuotes(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createPOOperationInfo(VWReceiveInstruction receiveOp, boolean ignoreVersion, int wsdlVersion) throws Exception {
        if (receiveOp == null) {
            return null;
        }
        String m_method = "createPOOperationInfo:" + receiveOp.getPartnerLinkName() + ":" + receiveOp.getOperationName();
        try {
            logger.entering(m_className, m_method);
            StringBuffer buf = new StringBuffer();
            boolean authentication = receiveOp.getAuthentication();
            boolean versionAgnostic = ignoreVersion;
            int paramNo = receiveOp.getCorrelationParameterSequenceNumber();
            boolean basic = paramNo >= 0 || receiveOp.getParameterDefinitions() != null;
            buf.append("<").append(EL_OPINFO).append(" xmlns=\"").append(WSConstants.getWSConstants((int)wsdlVersion).P8BPM_NS_GENERIC).append("\" ").append(ATTR_AUTHENTICATION).append("=\"").append(new Boolean(authentication).toString()).append("\" ").append(ATTR_VERSIONAGNOSTIC).append("=\"").append(new Boolean(versionAgnostic).toString()).append("\" ").append(ATTR_BASIC).append("=\"").append(new Boolean(basic).toString()).append("\">");
            if (basic) {
                if (paramNo >= 0) {
                    String expr = WSOperationInfoHelper.getRidOfQuotes(receiveOp.getCorrelationValueExpression());
                    buf.append("<").append(EL_BASICCORRSET).append(" ").append(ATTR_PARAMNO).append("=\"").append(paramNo).append("\" ").append(ATTR_PARAMNAME).append("=\"").append(receiveOp.getParameterDefinition(paramNo).getName()).append("\" ").append(ATTR_EXPR).append("=\"").append(expr == null ? "" : WSOperationInfoHelper.toMyXMLString(expr)).append("\"/>");
                }
            } else {
                String[][] corrSet = receiveOp.getCorrelationSetProperties();
                if (corrSet != null) {
                    String name = receiveOp.getCorrelationSetName();
                    buf.append("<").append(EL_ADVANCEDCORRSET).append(" ").append(ATTR_NAME).append("=\"").append(name == null ? "" : name).append("\">");
                    int nCorrs = corrSet.length;
                    for (int i = 0; i < nCorrs; ++i) {
                        String name2 = WSOperationInfoHelper.getRidOfQuotes(corrSet[i][0]);
                        String query = WSOperationInfoHelper.getRidOfQuotes(corrSet[i][1]);
                        buf.append("<").append(EL_PROPERTY).append(" ").append(ATTR_NAME).append("=\"").append(name2 == null ? "" : name2).append("\" ").append(ATTR_QUERY).append("=\"").append(query == null ? "" : WSOperationInfoHelper.toMyXMLString(query)).append("\"/>");
                    }
                    buf.append("</").append(EL_ADVANCEDCORRSET).append(">");
                }
            }
            buf.append("</").append(EL_OPINFO).append(">");
            String s = buf.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, s);
            }
            String string = s;
            Object var16_17 = null;
            logger.exiting(m_className, m_method);
            return string;
        }
        catch (Throwable t) {
            try {
                logger.throwing(m_className, m_method, t);
                String string = null;
                Object var16_18 = null;
                logger.exiting(m_className, m_method);
                return string;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public boolean getAuthentication() {
        return this.m_bAuthentication;
    }

    public boolean getVersionAgnostic() {
        return this.m_bVersionAgnostic;
    }

    public boolean getBasic() {
        return this.m_bBasic;
    }

    public int getBasicCorrSetParamNo() {
        return this.m_basicCorrSetParamNo;
    }

    public String getBasicCorrSetParamName() {
        return this.m_basicCorrSetParamName;
    }

    public String getBasicCorrSetParamExpr() {
        return this.m_basicCorrSetParamExpr;
    }

    public String getAdvCorrSetName() {
        return this.m_advCorrSetName;
    }

    public String[][] getAdvCorrSetProperties() {
        return this.m_advCorrSetProperties;
    }

    public static WSOperationInfoHelper getWSOperationInfoHelper(WSOperation op) {
        String m_method = "getWSOperationInfoHelper";
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, op == null ? "NOOP" : op.getName());
            }
            if (op != null && op.getOperation() != null) {
                VWXMLWrapper doc;
                Element opInfoEl;
                Element docEl = op.getOperation().getDocumentationElement();
                if (docEl == null) {
                    return null;
                }
                if (docEl.getFirstChild() == null) {
                    return null;
                }
                String val = docEl.getFirstChild().getNodeValue();
                if (val == null || val.indexOf(EL_OPINFO) == -1) {
                    return null;
                }
                val = XMLHelper.convertXMLChars(val);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, val);
                }
                if ((opInfoEl = (Element)(doc = new VWXMLWrapper(val)).getRootNode()) == null) {
                    return null;
                }
                return new WSOperationInfoHelper(opInfoEl);
            }
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
        }
        return null;
    }

    public static WSOperationInfoHelper getWSOperationInfoHelperFromString(String s) {
        String m_method = "getWSOperationInfoHelperFromString";
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, "getWSOperationInfoHelperFromString", "In=" + s);
            }
            s = XMLHelper.convertXMLChars(s);
            if (logger.isFinest()) {
                logger.finest(m_className, "getWSOperationInfoHelperFromString", "Modified In=" + s);
            }
            VWXMLWrapper w = new VWXMLWrapper(s);
            return new WSOperationInfoHelper((Element)w.getRootNode());
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getWSOperationInfoHelperFromString", t);
            return null;
        }
    }

    protected WSOperationInfoHelper(Element el) throws Exception {
        if (el == null) {
            throw new NullPointerException("null element.");
        }
        if (!EL_OPINFO.equals(el.getLocalName())) {
            throw new IllegalArgumentException("Missing element:OpInfo");
        }
        String namespace = el.getNamespaceURI();
        if (!(WSConstants.getWSConstants((int)0).P8BPM_NS_GENERIC.equals(namespace) || WSConstants.getWSConstants((int)10).P8BPM_NS_GENERIC.equals(namespace) || WSConstants.getWSConstants((int)20).P8BPM_NS_GENERIC.equals(namespace) || WSConstants.getWSConstants((int)30).P8BPM_NS_GENERIC.equals(namespace))) {
            throw new IllegalArgumentException("Nonmatched OpInfo NS:" + namespace);
        }
        if (!el.hasAttributes()) {
            throw new IllegalArgumentException("OpInfo has no attributes..");
        }
        String value = el.getAttribute(ATTR_AUTHENTICATION);
        if (value != null && value.trim().length() > 0) {
            this.m_bAuthentication = new Boolean(value);
        }
        if ((value = el.getAttribute(ATTR_VERSIONAGNOSTIC)) != null && value.trim().length() > 0) {
            this.m_bVersionAgnostic = new Boolean(value);
        }
        if ((value = el.getAttribute(ATTR_BASIC)) != null && value.trim().length() > 0) {
            this.m_bBasic = new Boolean(value);
        }
        if (!el.hasChildNodes()) {
            return;
        }
        if (this.m_bBasic) {
            Element basicCorrSet = (Element)VWXMLWrapper.getNodeNamed(el, EL_BASICCORRSET);
            if (basicCorrSet == null) {
                return;
            }
            value = basicCorrSet.getAttribute(ATTR_PARAMNO);
            if (value != null && value.trim().length() > 0) {
                this.m_basicCorrSetParamNo = Integer.parseInt(value);
            }
            if (this.m_basicCorrSetParamNo >= 0) {
                this.m_basicCorrSetParamName = basicCorrSet.getAttribute(ATTR_PARAMNAME);
                this.m_basicCorrSetParamExpr = WSOperationInfoHelper.convertMyXMLChars(basicCorrSet.getAttribute(ATTR_EXPR));
            }
        } else {
            int nProps;
            Element advCorrSet = (Element)VWXMLWrapper.getNodeNamed(el, EL_ADVANCEDCORRSET);
            if (advCorrSet == null) {
                return;
            }
            this.m_advCorrSetName = advCorrSet.getAttribute(ATTR_NAME);
            Node[] properties = VWXMLWrapper.getNodesNamed(advCorrSet, EL_PROPERTY);
            int n = nProps = properties == null ? 0 : properties.length;
            if (nProps > 0) {
                this.m_advCorrSetProperties = new String[nProps][2];
                for (int iP = 0; iP < nProps; ++iP) {
                    Element pEl = (Element)properties[iP];
                    this.m_advCorrSetProperties[iP][0] = pEl.getAttribute(ATTR_NAME);
                    this.m_advCorrSetProperties[iP][1] = WSOperationInfoHelper.convertMyXMLChars(pEl.getAttribute(ATTR_QUERY));
                }
            }
        }
    }

    public String[] getWSListenerParamsForCreateLiveWorkObject() {
        if (!this.m_bVersionAgnostic) {
            return null;
        }
        if (this.m_bBasic) {
            if (this.m_basicCorrSetParamName != null) {
                return new String[]{BASIC_MARKER, this.m_basicCorrSetParamName};
            }
            return DEF_BASIC_AGNOSTICS;
        }
        if (this.m_advCorrSetProperties == null) {
            return DEF_ADV_AGNOSTICS;
        }
        int nProps = this.m_advCorrSetProperties.length;
        String[] res = new String[nProps + 1];
        res[0] = ADV_MARKER;
        for (int i = 0; i < nProps; ++i) {
            res[i + 1] = this.m_advCorrSetProperties[i][1];
        }
        return res;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(EL_OPINFO).append(" xmlns=\"").append(WSConstants.getDefaultWSConstants().P8BPM_NS_GENERIC).append("\" ").append(ATTR_AUTHENTICATION).append("=\"").append(new Boolean(this.m_bAuthentication).toString()).append("\" ").append(ATTR_VERSIONAGNOSTIC).append("=\"").append(new Boolean(this.m_bVersionAgnostic).toString()).append("\" ").append(ATTR_BASIC).append("=\"").append(new Boolean(this.m_bBasic).toString()).append("\">");
        if (this.m_bBasic) {
            if (this.m_basicCorrSetParamNo >= 0) {
                buf.append("<").append(EL_BASICCORRSET).append(" ").append(ATTR_PARAMNO).append("=\"").append(this.m_basicCorrSetParamNo).append("\" ").append(ATTR_PARAMNAME).append("=\"").append(this.m_basicCorrSetParamName).append("\" ").append(ATTR_EXPR).append("=\"").append(this.m_basicCorrSetParamExpr == null ? "" : WSOperationInfoHelper.toMyXMLString(this.m_basicCorrSetParamExpr)).append("\"/>");
            }
        } else if (this.m_advCorrSetProperties != null) {
            buf.append("<").append(EL_ADVANCEDCORRSET).append(" ").append(ATTR_NAME).append("=\"").append(this.m_advCorrSetName == null ? "" : this.m_advCorrSetName).append("\">");
            int nCorrs = this.m_advCorrSetProperties.length;
            for (int i = 0; i < nCorrs; ++i) {
                String name2 = this.m_advCorrSetProperties[i][0];
                String query = this.m_advCorrSetProperties[i][1];
                buf.append("<").append(EL_PROPERTY).append(" ").append(ATTR_NAME).append("=\"").append(name2 == null ? "" : name2).append("\" ").append(ATTR_QUERY).append("=\"").append(query == null ? "" : WSOperationInfoHelper.toMyXMLString(query)).append("\"/>");
            }
            buf.append("</").append(EL_ADVANCEDCORRSET).append(">");
        }
        buf.append("</").append(EL_OPINFO).append(">");
        return buf.toString();
    }

    private static void testCase(boolean basic) {
        try {
            StringBuffer buf = new StringBuffer();
            boolean authentication = false;
            boolean versionAgnostic = false;
            int paramNo = 0;
            buf.append("<").append(EL_OPINFO).append(" xmlns=\"").append(WSConstants.getDefaultWSConstants().P8BPM_NS_GENERIC).append("\" ").append(ATTR_AUTHENTICATION).append("=\"").append(new Boolean(authentication).toString()).append("\" ").append(ATTR_VERSIONAGNOSTIC).append("=\"").append(new Boolean(versionAgnostic).toString()).append("\" ").append(ATTR_BASIC).append("=\"").append(new Boolean(basic).toString()).append("\">").append("\n");
            if (basic) {
                if (paramNo >= 0) {
                    String expr = "PARAM EXPR GOES HERE";
                    String paramName = "PARAM NAME GOES HERE";
                    buf.append("<").append(EL_BASICCORRSET).append(" ").append(ATTR_PARAMNO).append("=\"").append(paramNo).append("\" ").append(ATTR_PARAMNAME).append("=\"").append(paramName).append("\" ").append(ATTR_EXPR).append("=\"").append(expr == null ? "" : XMLHelper.toXMLString(expr)).append("\"/>").append("\n");
                }
            } else {
                String[][] corrSet = new String[][]{{"name1", "expr1"}, {"name2", "expr2"}, {"name3", "//temp//Root/*"}};
                if (corrSet != null) {
                    String name = "CORR SET NAME";
                    buf.append("<").append(EL_ADVANCEDCORRSET).append(" ").append(ATTR_NAME).append("=\"").append(name == null ? "" : name).append("\">");
                    int nCorrs = corrSet.length;
                    for (int i = 0; i < nCorrs; ++i) {
                        String name2 = corrSet[i][0];
                        String query = corrSet[i][1];
                        buf.append("<").append(EL_PROPERTY).append(" ").append(ATTR_NAME).append("=\"").append(name2 == null ? "" : name2).append("\" ").append(ATTR_QUERY).append("=\"").append(query == null ? "" : WSOperationInfoHelper.toMyXMLString(query)).append("\"/>").append("\n");
                    }
                    buf.append("</").append(EL_ADVANCEDCORRSET).append(">").append("\n");
                }
            }
            buf.append("</").append(EL_OPINFO).append(">").append("\n");
            String s = buf.toString();
            System.out.println((basic ? "" : "NON-") + "BASIC SAMPLES:");
            System.out.println(s);
            System.out.println();
            WSOperationInfoHelper h = WSOperationInfoHelper.getWSOperationInfoHelperFromString(s);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        WSOperationInfoHelper.testCase(false);
        WSOperationInfoHelper.testCase(true);
        try {
            String s = "&lt;OpInfo xmlns=\"" + WSConstants.getDefaultWSConstants().P8BPM_NS_GENERIC + "\"" + " authentication=\"false\" versionAgnostic=\"true\"" + " basic=\"false\"&gt;&lt;advancedCorrSet" + " name=\"CRID\"&gt;&lt;property name=\"ssn\"" + " query=\"/*[local-name()=!quot;!receiveRatingRequest!quot;!]/*[local-name()=!quot;!SSN!quot;!]\"/&gt;&lt;property" + " name=\"brokerCo\"" + " query=\"/*[local-name()=!quot;!receiveRatingRequest!quot;!]/*[local-name()=!quot;!brokerCo!quot;!]\"/&gt;" + "&lt;/advancedCorrSet&gt;&lt;/OpInfo&gt;";
            WSOperationInfoHelper h = WSOperationInfoHelper.getWSOperationInfoHelperFromString(s);
            System.out.println("getWSListenerParamsForCreateLiveWorkObject=" + Logger.asString(h.getWSListenerParamsForCreateLiveWorkObject()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private static String toMyXMLString(String buf) {
        int i;
        if (buf == null) {
            return "";
        }
        boolean specialChar = false;
        for (i = 0; i < buf.length() && !specialChar; ++i) {
            switch (buf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    specialChar = true;
                }
            }
        }
        if (!specialChar) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block7: for (i = 0; i < buf.length(); ++i) {
            switch (buf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    for (int k = 0; k < 8; ++k) {
                        if (buf.charAt(i) != XML_ENCODED_CHARS[k]) continue;
                        sb.append(XML_ENCODED_PATTERNS[k]);
                        continue block7;
                    }
                    continue block7;
                }
                default: {
                    sb.append(buf.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static String convertMyXMLChars(String buf) {
        if (buf == null) {
            return "";
        }
        boolean foundIt = false;
        for (int i = 0; i < 8 && !foundIt; ++i) {
            foundIt = buf.indexOf(XML_ENCODED_PATTERNS[i]) != -1;
        }
        if (!foundIt) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block1: for (int j = 0; j < buf.length(); ++j) {
            if (buf.charAt(j) == '!') {
                for (int i = 0; i < 8; ++i) {
                    if (!buf.startsWith(XML_ENCODED_PATTERNS[i], j)) continue;
                    j += XML_ENCODED_LEN[i];
                    sb.append(XML_ENCODED_CHARS[i]);
                    continue block1;
                }
                continue;
            }
            sb.append(buf.charAt(j));
        }
        return sb.toString();
    }
}

